import cv2
import sys
import numpy as np
import serial 
(major_ver, minor_ver, subminor_ver) = (cv2.__version__).split('.')

"""---------------------------- Instruction  ------------------------"""

#       Ensure Baud Rate and Com Matches your bluetooth or USB connection from Datas folder
#       Select Source of video
#       Draw ROI box on first activation of the program
#       and press Enter

"""---------------------------- Keyboard Commands ------------------------"""
#       e - retarget object
#       p - Disengage Arduino
#       q - quit
#   Enter - ok Engage to Arduino and start tracking
"""----------------- Setup some Dependacy and Libraries ------------------"""

#   Required opencv-contrib-python 4.11.0.86
#   open your open RUN and type CMD
#   type this
#   pip install opencv-contrib-python
#   or for update to older versions
#   pip uninstall opencv-contrib-python opencv-python opencv-contrib-python-headless && pip install opencv-contrib-python

"""----------------- Setup some Dependacy and Libraries ------------------"""

def selectTracker(tracker_type):
    tracker_types = ['BOOSTING', 'MIL','KCF', 'TLD', 'MEDIANFLOW', 'CSRT', 'MOSSE']
    tracker_type = tracker_types[tracker_type]
    if int(minor_ver) < 3:
        tracker = cv2.Tracker_create(tracker_type)
    else:
        if tracker_type == 'BOOSTING':              #selectTracker(0)
            tracker = cv2.TrackerBoosting_create()
        if tracker_type == 'MIL':                   #selectTracker(1)
            tracker = cv2.TrackerMIL_create()
        if tracker_type == 'KCF':                   #selectTracker(2)
            tracker = cv2.TrackerKCF_create()
        if tracker_type == 'TLD':                   #selectTracker(3)
            tracker = cv2.TrackerTLD_create()
        if tracker_type == 'MEDIANFLOW':            #selectTracker(4)
            tracker = cv2.TrackerMedianFlow_create()
        if tracker_type == 'CSRT':                  #selectTracker(5)
            tracker = cv2.TrackerCSRT_create()
        if tracker_type == 'MOSSE':                 #selectTracker(6)
            tracker = cv2.TrackerMOSSE_create()
    return tracker

"""===============================get Com # from com.txt file========================================="""
#-------------------txt string----use for external config-------           
                    #txt = Path('datas.txt').read_text()
                    #txt = Path('datas.txt').readline(1)
                    #txt = open('datas.txt').read()
"""===================================================================================================="""
""" all associated info in the datas folder in your Txt file and place it in datas folder directory next to the bat file """

# Serial communication
URL = 'http://192.168.4.1:80/'
txt = open('datas/com.txt').readline()
baud = open('datas/baud.txt').readline()
soon = open('datas/source.txt').readline()
# ipt = Screen Filter  0 - 640 location of objects on the screen by targeting computer
ipt = open('datas/ipt.txt')
ipt_line = ipt.readlines()

"""====================================Serial connection============================================================="""
ard = serial.Serial(txt, (baud))
#ard = serial.Serial(COM53, 115200) # or you can uncomment this and add your COM number here

"""===========================================Select a Tracker of Choice ============================================"""

def main():
    print("Preparing Application")
    tracker = selectTracker(5)
    
#====================================Video source from Datas Folder================================================"""
    
    #video = cv2.VideoCapture(soon)#use Video.mp4
    
#====================================Video source ================================================================="""
    #video = cv2.VideoCapture(URL) # ESP32 Camera see synerflight add on integration
    #video = cv2.VideoCapture('video.mp4')#use Video.mp4 
    video = cv2.VideoCapture(0) # for using CAMERA
  
#=================================================================================================================="""    
    if not video.isOpened():
        print("error opening video file")
        sys.exit()
    ok, frame = video.read()
    frame = cv2.resize(frame, (720, 480))
    if not ok:
        print('error reading video file')
        sys.exit()

       
    bbox = (287, 23, 86, 320)
    bbox = cv2.selectROI(frame, False)
    ok = tracker.init(frame, bbox)
    roi_selector_active = False
    lock_status="LOCKDOWN STATUS: PASSIVE"
    lock_status_c = (0, 0, 255)
    while True:
        ret, frame = video.read()
        frame = cv2.resize(frame, (720, 480))
        if not ret:
            break
#====================================Video Grayscale uncomment to use ================================================================="""
        
        #gray = cv2.cvtColor(frame, cv2.COLOR_BGR2GRAY)
        #frame = cv2.cvtColor(gray, cv2.COLOR_GRAY2BGR)
        
#====================================Video ROI Box ===================================================================================="""       
        if roi_selector_active:

            bbox = cv2.selectROI(frame, True)
            #ok = tracker.init(frame, bbox) # uncomment this for Manual ROI box also see: Keyboard Commands
            ok = tracker.init(frame, targetbox) # uncomment this for Auto ROI box also see: Keyboard Commands
            

            roi_selector_active = False
        ok, bbox = tracker.update(frame)

        
        if ok:
            lock_status="Synerflight"
            lock_status_c = (0, 255, 0)
            cx = int(bbox[0] + bbox[2] / 2)  # Bonding Box x Coordinate
            cy = int(bbox[1] + bbox[3] / 2)  # Bonding Box y Coordinate
            half_size = 40 // 2  # Half diameter of square size
            gap = 8  # Space between square and lines
            
##--------------------------------- Draw some target Lines ----------------------------------##
            
            dark_green = (0, 180, 0)
            line_thickness = 2
            cv2.line(frame, (cx - half_size, cy - half_size), (cx - half_size + gap, cy - half_size), dark_green, line_thickness)
            cv2.line(frame, (cx + half_size - gap, cy - half_size), (cx + half_size, cy - half_size), dark_green, line_thickness)
            cv2.line(frame, (cx - half_size, cy + half_size), (cx - half_size + gap, cy + half_size), dark_green, line_thickness)
            cv2.line(frame, (cx + half_size - gap, cy + half_size), (cx + half_size, cy + half_size), dark_green, line_thickness)
            cv2.line(frame, (cx - half_size, cy - half_size), (cx - half_size, cy - half_size + gap), dark_green, line_thickness)
            cv2.line(frame, (cx + half_size, cy - half_size), (cx + half_size, cy - half_size + gap), dark_green, line_thickness)
            cv2.line(frame , (cx - half_size , cy + half_size ), (cx - half_size , cy + half_size - gap ), dark_green , line_thickness )
            cv2.line(frame , (cx + half_size , cy + half_size ), (cx + half_size , cy + half_size - gap ), dark_green , line_thickness )
            cv2.line(frame , (cx , cy - half_size - gap ), (cx , 0 ), dark_green , line_thickness )
            cv2.line(frame , (cx , cy + half_size + gap ), (cx , frame.shape[0] ), dark_green , line_thickness )
            cv2.line(frame , (cx - half_size - gap , cy ), (0 , cy ), dark_green , line_thickness )
            cv2.line(frame , (cx + half_size + gap , cy ), (frame.shape[1] , cy ), dark_green , line_thickness )
            font = cv2.FONT_HERSHEY_SIMPLEX
            font_scale = 0.5
            font_thickness = 2
            text = f'x: {cx}, y: {cy}'
            text_position = (10, 20)
            cv2.putText(frame, text, text_position, font, font_scale, dark_green, font_thickness)


        else:
            lock_status="LOCKDOWN STATUS: PASSIVE"
        height, width = frame.shape[:2]
        corner_length = 40  # Length of corner lines
        offset = 130  # Inward offset of corner lines
        cv2.line(frame, (offset, offset), (offset + corner_length, offset), (0, 0, 255), 2)  # Sol üst köşe
        cv2.line(frame, (offset, offset), (offset, offset + corner_length), (0, 0, 255), 2)
        cv2.line(frame, (width - offset, offset), (width - offset - corner_length, offset), (0, 0, 255), 2)  # Sağ üst köşe
        cv2.line(frame, (width - offset, offset), (width - offset, offset + corner_length), (0, 0, 255), 2)
        cv2.line(frame, (offset, height - offset), (offset + corner_length, height - offset), (0, 0, 255), 2)  # Sol alt köşe
        cv2.line(frame, (offset, height - offset), (offset, height - offset - corner_length), (0, 0, 255), 2)
        cv2.line(frame, (width - offset, height - offset), (width - offset - corner_length, height - offset), (0, 0, 255), 2)  # Sağ alt köşe
        cv2.line(frame, (width - offset, height - offset), (width - offset, height - offset - corner_length), (0, 0, 255), 2)
        
        height, width = frame.shape[:2]
        center_x, center_y = width // 2, height // 2
        sight_size = 30   #effective target size

##--------------------------------- Center Target Draw ----------------------------------##    
        cv2.line(frame, (center_x - sight_size, center_y), 
                (center_x + sight_size, center_y), (0, 0, 255), 2)
        cv2.line(frame, (center_x, center_y - sight_size), 
                (center_x, center_y + sight_size), (0, 0, 255), 2)
        
##--------------------------------- Center Target Draw ---------------------------------##    
        xaxis = center_x #X Axis 
        yaxis = center_y #Y Axis
##--------------------------------- BBbox Draw -----------------------------------------##
        
        distance = np.sqrt((cx - center_x) ** 2 + (cy - center_y) ** 2)
        threshold_distance = int(ipt_line[4]) # Center filter how large you want the null point to be center 
        #threshold_distance = 45
        
        if distance < threshold_distance:
            text = "LOCK"
            c = (0, 255, 0)  # green color
        else:
            text = "SEARCH"
            c = (0, 0, 255)  # Red Color
        text_size1 = cv2.getTextSize(text, cv2.FONT_HERSHEY_SIMPLEX, 1, 2)[0]
        text1_x = (frame.shape[1] - text_size1[0]) // 2
        text1_y = frame.shape[0] - 50  # Scroll to the bottom middle
        cv2.putText(frame, text, (text1_x, text1_y), cv2.FONT_HERSHEY_SIMPLEX, 1,c, 2)
        text_size2 = cv2.getTextSize(lock_status, cv2.FONT_HERSHEY_SIMPLEX, 0.5, 2)[0]
        text2_x = (frame.shape[1] - text_size2[0]) // 2
        text2_y = frame.shape[0] - 20
        cv2.putText(frame, lock_status, (text2_x, text2_y), cv2.FONT_HERSHEY_SIMPLEX, 0.5,lock_status_c, 2)
        cv2.imshow("Tracking", frame)        
        key = cv2.waitKey(1)
#==================================== ADDITIONAL CODES Filtering objects along the screen Arduino to serial ======================================"""

        #X Axis
        IPT1 = (f"{'L' * (cx < int(ipt_line[2]))}"                      #Left of screen
                f"{'X' * ((cx - center_x)** 2 < threshold_distance)}"   #Center X axis of screen
                f"{'R' * (cx > int(ipt_line[6]))}".encode())            #Right of screen


        #Y Axis 
        IPT2 = (f"{'U' * (cy < int(ipt_line[8]))}"                      #Up of screen
                f"{'Y' * ((cy - center_y)** 2 < threshold_distance)}"   #Center Y axis of screen
                f"{'D' * (cy > int(ipt_line[12]))}".encode())           #Down of screen

        #Lock Axis
        LOCK1 =  (f"{'C' * (distance < threshold_distance)}".encode()) #send 'C' Serial (Centered)

        #Engage or Disengage tracking CV Control
        CVCTL =  (f"{'P' * (key == ord('p'))}"          #send 'P' serial
                  f"{'O' * (key == ord('o'))}".encode())#send 'O' serial


        #Numpad control
        NUMCTL = (f"{'1' * (key == ord('1'))}"          #send '1' serial
                  f"{'2' * (key == ord('2'))}"          #send '2' serial
                  f"{'3' * (key == ord('3'))}"          #send '3' serial
                  f"{'4' * (key == ord('4'))}"          #send '4' serial
                  f"{'5' * (key == ord('5'))}"          #send '5' serial
                  f"{'6' * (key == ord('6'))}"          #send '6' serial
                  f"{'7' * (key == ord('7'))}"          #send '7' serial
                  f"{'8' * (key == ord('8'))}"          #send '8' serial
                  f"{'9' * (key == ord('9'))}".encode())#send '9' serial

        #engage tracking
        RETARGET =  (f"{'E' * (key == ord('e'))}".encode())#send 'E' serial
        
#===================================this what shows up on your CMD :uncomment to activate ========================================================"""                                                      
        print(IPT1)
        print(IPT2)
        print(LOCK1)
        print(CVCTL)
        print(RETARGET)
        print(NUMCTL)
        
        #print(cy)
        #print(cx)
#===================================this whats send to your Arduino :uncomment to activate ========================================================""" 
        ard.write(IPT1) # if its on the X axis of the screen
        ard.write(IPT2) # if its on the Y axis of the screen
        ard.write(LOCK1) # if its on the Center of the screen
        ard.write(RETARGET) # New Target , Center on screen or ROI box
        ard.write(NUMCTL) # Numpad Directional control
        ard.write(CVCTL) # Engage or Disengage Tracking CV Control
        
        #ard.write(f"{cx}".encode())
        #ard.write(f"{cy}".encode())
        
##------------------------------------------------------------------ Keyboard Commands ---------------------------------------------------------##        
         
        if key == ord('q'): # quit
            break
        elif key == ord('e'): # Retarget
            roi_selector_active = True
            targetbox = (240, 160, 230, 170)  #uncomment this (auto ROI box) Target must be in the center

##-------------------------------------------------------- Shutdown Application Commands ---------------------------------------------------------##              


            
    video.release()
    cv2.destroyAllWindows()

if __name__ == "__main__":
    main()
